options nodate nonumber nocenter pagesize=max ls=72;

data have;
   do state = 'KY', 'CA', 'MS';
      do b = 1 to 3;
         do c = 200, 100;
            output;
         end;
      end;
   end;
   stop;
run; 

title 'Data Set HAVE';

proc print data=have (obs=11);
run;


/* Traditional method 1                */
/* Multiple passes through the data    */
/* Don't let me catch you doing this.  */

data ex1_KY;
   set have;
   if state = 'KY';
run;

data ex1_CA;
   set have;
   if state = 'CA';
run;

data ex1_MS;
   set have;
   if state = 'MS';
run;


/* It would be better to auto-generate code  */
/* like this:                                */

/* Traditional method 2                      */
/* Single pass through the data              */

data ex2_KY
     ex2_CA
     ex2_MS;

   set have;

   select (state);
      when ('KY') output ex2_KY;
      when ('CA') output ex2_CA;
      when ('MS') output ex2_MS;
      otherwise error 'Unknown State ' state=;
   end;

run;

/* The problem is, how do you generate the code?  */


/* Traditional method 3                   */
/* Use PROC SQL to create macro variables */

proc sql noprint;
   select distinct 
            'ex3_' || state,
            cats('when (', 
                 quote(state), 
                 ') output ex3_', state, ';')
   into     
            :DATASETS separated by ' ',
            :WHENS    separated by ' '
   from   
            have;
quit;

%put DATASETS=%quote(&DATASETS.);
%put WHENS   =%quote(&WHENS.);


options symbolgen;

data &DATASETS;
   set have;
   select(state);
      &WHENS
      otherwise;
   end;
run;

options nosymbolgen;


/* Traditional method 4                     */
/* Use data step to generate code           */
/* Using CALL EXECUTE would be very similar */

filename source1 temp;
filename source2 temp;

data _null_;

   file source1;

   if _n_ =1 then
      put 'data ';

   do until (last.state);
      set have end=eod;
      by state notsorted;
   end;

   put 'ex4_' state;

   if eod then 
      put ';';

   file source2;

   put 'when (' state $quote4. ') output ex4_' state ';';

run;

%include source1 / source2;
   set have;
   select(state);
      %include source2 / source2;
      otherwise;
   end;
run;

filename source1 clear;
filename source2 clear;


/* Simple DOW-loop */

data _null_;
   /* Code to run before BY-group */
   putlog 'INFO: Starting BY-group';
   do until (last.state);
      set have;
      by state notsorted;
      /* Code to run for each observation */
      putlog '   ' b= c=;
   end;
   /* Code to run after BY-group */
   putlog 'INFO: Ending BY-group' state=;
run;

/* Traditional approach */

data _null_;
   set have;
   by state notsorted;
   /* Code to run before BY-group */
   if first.state then 
      putlog 'INFO: Starting BY-group';
   /* Code to run for each observation */
   putlog '   ' b= c=;
   /* Code to run after BY-group */
   if last.state then 
      putlog 'INFO: Ending BY-group' state=;
run;

/* New method - hash objects */

data _null_;

   declare hash group;

   group = _new_ hash(ordered: 'ascending');
   group.definekey('_unique_Key');
   group.definedata('State', 'b', 'c');
   group.definedone();

   do until (last.state);
      set have;
      by state notsorted;
      _unique_key + 1;
      group.add();
   end;

   group.output(dataset: 'ex5_' || state);

   group.delete();

run;


/* Same code, with some debugging aids */

data _null_;
   declare hash group;
   putlog 'At top';
   group = _new_ hash(ordered: 'ascending');
   group.definekey('_unique_Key');
   group.definedata('state', 'b', 'c');
   group.definedone();
   do until (last.state);
      set have (where=(state = 'KY'));
      by state notsorted;
      _unique_key + 1;
      group.add();
      putlog _unique_key=2. @17 state= b= c= +1 last.state= +1 _n_= ;
   end;
   putlog 'At bottom';
   group.output(dataset: 'ex6_' || state);
   group.delete();
run;


data bigtest;
   do state = 'NH', 'NJ', 'NM', 'NY', 'IA', 'NV', 'OK', 'HI', 'AR', 
              'TX', 'PW', 'DE', 'AL', 'WI', 'RI', 'FM', 'VI', 'VA', 
              'OR', 'UT', 'MI', 'WA', 'ID', 'IN', 'MP', 'DC', 'KY', 
              'MD', 'AZ';
      do b = 1 to 300;
         do c = 1 to 300;
            d = ranuni(0); e = ranuni(0); f = ranuni(0); g = ranuni(0);
            length h i $40.; retain h i ' ';
            output;
         end;
      end;
   end;
run;

data _null_;

   declare hash group;

   group = _new_ hash(ordered: 'ascending');
   group.definekey('_unique_Key');
   group.definedata('state', 'b', 'c', 'd', 'e', 'f', 'g', 
                    'h', 'i');
   group.definedone();

   do until (last.state);
      set bigtest;
      by state notsorted;
      _unique_key + 1;
      group.add();
   end;

   group.output(dataset: 'ex7_' || state);

   group.delete();

run;

proc sql noprint;
   select distinct 
            'ex8_' || state,
            cats('when (', quote(state), ') output ex8_', state, ';')
   into     
            :DATASETS separated by ' ',
            :WHENS    separated by ' '
   from   
            bigtest;
quit;

data &DATASETS;
   set bigtest;
   select(state);
      &WHENS
      otherwise;
   end;
run;


filename source1 temp;
filename source2 temp;

data _null_;

   file source1;

   if _n_ =1 then
      put 'data ';

   do until (last.state);
      set bigtest end=eod;
      by state notsorted;
   end;

   put 'ex9_' state;

   if eod then 
      put ';';

   file source2;
   put 'when (' state $quote4. ') output ex9_' state ';';

run;

%include source1;
   set bigtest;
   select(state);
      %include source2;
      otherwise;
   end;
run;

filename source1 clear;
filename source2 clear;


/* Hash, not using DOW */

data _null_;

   declare hash group;

   set bigtest;
   by state notsorted;

   if first.state then 
      do;
      group = _new_ hash(ordered: 'ascending');
      group.definekey('_unique_Key');
      group.definedata('state', 'b', 'c', 'd', 'e', 'f', 'g', 
                       'h', 'i');
      group.definedone();
      end;

   _unique_key + 1;
   group.add();

   if last.state then 
      do;
      group.output(dataset: 'ex10_' || state);
      group.delete();
      end;

run;

/* Input not ordered by group, use two hashes.  */
/* Must be able to fit all data into memory     */

data _null_;

   declare hash  alldata;
   declare hiter all_iter; 
   declare hash  groupdata;

   alldata  = _new_ hash(ordered: 'ascending');
   all_iter   = _new_ hiter('alldata');

   alldata.definekey('State', '_unique_Key');
   alldata.definedata('state', 'b', 'c', 'd', 'e', 'f', 'g', 
                      'h', 'i', '_unique_Key');
   alldata.definedone();

   do until (eod);
      set bigtest end=eod;
      _unique_key + 1;
      alldata.add();
   end;

   rc = all_iter.first();
   do outobs = 1 by 1 while (rc = 0);
      lagstate = lag(state);
      if state ne lag(state) then 
         do; 
         if outobs ne 1 then 
            do;
            groupdata.output(dataset: 'ex_' || lagstate);
            groupdata.delete();
            end;
         groupdata = _new_ hash(ordered: 'ascending');
         groupdata.definekey('_unique_key');
         groupdata.definedata('state', 'b', 'c', 'd', 'e', 'f', 'g', 
                              'h', 'i');
         groupdata.definedone();
         end;
      groupdata.add();
      rc = all_iter.next();      
   end; 

   groupdata.output(dataset: 'ex11_' || state);
   groupdata.delete();
   alldata.delete();

   stop;

run;
